; BLESS Include File
; Use 'Include "bless.bb"' in your source code

; BLESS (BLitz EventS System) by Chad Dylan Long
; Copyright 2004 Minty Software, LLC
; www.mintysoftware.com

; ---------------------------------------
; ---------- BLESS CONSTANTS ------------

; Default Method for BLESS IDs
; Suitable for BlitzPlus only
; e.g. BLESS+0, BLESS+1, BLESS+2, etc
; up to BLESS+2047 (2048 registered events available)
Const BLESS = $D800
Const BLESSMAX = $DFFF

; Alternate Method for BLESS IDs
; Suitable for Blitz3D or BlitzPlus
; e.g. BLESS_0, BLESS_1, BLESS_2, etc
; up to BLESS_110 (111 registered events available)
Const BLESS_0 = 84
Const BLESS_1 = 85
Const BLESS_2 = 89
Const BLESS_3 = 90
Const BLESS_4 = 91
Const BLESS_5 = 92
Const BLESS_6 = 93
Const BLESS_7 = 94
Const BLESS_8 = 95
Const BLESS_9 = 96
Const BLESS_10 = 97
Const BLESS_11 = 98
Const BLESS_12 = 99
Const BLESS_13 = 103
Const BLESS_14 = 104
Const BLESS_15 = 105
Const BLESS_16 = 106
Const BLESS_17 = 107
Const BLESS_18 = 108
Const BLESS_19 = 109
Const BLESS_20 = 110
Const BLESS_21 = 111
Const BLESS_22 = 113
Const BLESS_23 = 114
Const BLESS_24 = 116
Const BLESS_25 = 117
Const BLESS_26 = 118
Const BLESS_27 = 119
Const BLESS_28 = 120
Const BLESS_29 = 122
Const BLESS_30 = 124
Const BLESS_31 = 127
Const BLESS_32 = 128
Const BLESS_33 = 129
Const BLESS_34 = 130
Const BLESS_35 = 131
Const BLESS_36 = 132
Const BLESS_37 = 133
Const BLESS_38 = 134
Const BLESS_39 = 135
Const BLESS_40 = 136
Const BLESS_41 = 137
Const BLESS_42 = 138
Const BLESS_43 = 139
Const BLESS_44 = 140
Const BLESS_45 = 142
Const BLESS_46 = 143
Const BLESS_47 = 152
Const BLESS_48 = 154
Const BLESS_49 = 155
Const BLESS_50 = 158
Const BLESS_51 = 159
Const BLESS_52 = 163
Const BLESS_53 = 165
Const BLESS_54 = 166
Const BLESS_55 = 167
Const BLESS_56 = 168
Const BLESS_57 = 169
Const BLESS_58 = 170
Const BLESS_59 = 171
Const BLESS_60 = 172
Const BLESS_61 = 173
Const BLESS_62 = 175
Const BLESS_63 = 177
Const BLESS_64 = 180
Const BLESS_65 = 182
Const BLESS_66 = 185
Const BLESS_67 = 186
Const BLESS_68 = 187
Const BLESS_69 = 188
Const BLESS_70 = 189
Const BLESS_71 = 190
Const BLESS_72 = 191
Const BLESS_73 = 192
Const BLESS_74 = 193
Const BLESS_75 = 194
Const BLESS_76 = 195
Const BLESS_77 = 196
Const BLESS_78 = 198
Const BLESS_79 = 202
Const BLESS_80 = 204
Const BLESS_81 = 206
Const BLESS_82 = 212
Const BLESS_83 = 213
Const BLESS_84 = 214
Const BLESS_85 = 215
Const BLESS_86 = 216
Const BLESS_87 = 217
Const BLESS_88 = 218
Const BLESS_89 = 224
Const BLESS_90 = 225
Const BLESS_91 = 226
Const BLESS_92 = 228
Const BLESS_93 = 238
Const BLESS_94 = 239
Const BLESS_95 = 240
Const BLESS_96 = 241
Const BLESS_97 = 242
Const BLESS_98 = 243
Const BLESS_99 = 244
Const BLESS_100 = 245
Const BLESS_101 = 246
Const BLESS_102 = 247
Const BLESS_103 = 248
Const BLESS_104 = 249
Const BLESS_105 = 250
Const BLESS_106 = 251
Const BLESS_107 = 252
Const BLESS_108 = 253
Const BLESS_109 = 254
Const BLESS_110 = 255


; ---------------------------------------------
; ---------- HELPER TYPE for BLESS ------------

; Required for receiving EventData from Bless Events
; Use the Bless_EventData function to fill type object
Type BlessEventData
	Field wParam%, lParam%
End Type
Global Bless_EventData.BlessEventData = New BlessEventData



; ----------------------------------------------------
; --------- HELPER TYPES for EXAMPLES ONLY -----------

; You can look these up on MSDN
; You don't need them for minimal BLESS stuff
Type BlessNMHDR
	Field hwndFrom%, idFrom%, code%
End Type

Type BlessWindowPlacement
	Field length%, flags%, showcmd%, minposX%, minposY%, maxposX%, maxposY%
	Field normalposLeft%, normalposTop%, normalposRight%, normalposBottom%
End Type

Type BlessDRAWITEMSTRUCT
    Field CtlType%, CtlID%, itemID%, itemAction%, itemState%, hwndItem%
    Field hDC%, rcItem_l%, rcItem_t%, rcItem_r%, rcItem_b%, pItemData%
End Type

Global Bless_NMHDR.BlessNMHDR = New BlessNMHDR
Global Bless_WP.BlessWindowPlacement = New BlessWindowPlacement
Bless_WP\length = 44
Global Bless_DrawItem.BlessDRAWITEMSTRUCT = New BlessDRAWITEMSTRUCT



; -----------------------------------------
; ---------- WINDOWS CONSTANTS ------------

; These are notifications and messages (i.e. events)
; that BLESS should be able to detect.
; Look them up on MSDN.
; Disclaimer: This is probably an incomplete list
; ... and may even be inaccurate (mistakes happen)

; User Interface - Windowing - Message & Message Queue Notifications
Const WM_APP						= $8000
Const WM_USER						= $0400

; User Interface - General Control Messages & Notifications
Const WM_NOTIFY						= $004E
Const WM_NOTIFYFORMAT				= $0055
Const NM_FIRST						= 0
Const NM_OUTOFMEMORY				= NM_FIRST-1
Const NM_CLICK						= NM_FIRST-2	; uses NMCLICK struct
Const NM_DBLCLK						= NM_FIRST-3
Const NM_RETURN						= NM_FIRST-4
Const NM_RCLICK						= NM_FIRST-5	; uses NMCLICK struct
Const NM_RDBLCLK					= NM_FIRST-6
Const NM_SETFOCUS					= NM_FIRST-7
Const NM_KILLFOCUS					= NM_FIRST-8
Const NM_CUSTOMDRAW					= NM_FIRST-12
Const NM_HOVER						= NM_FIRST-13
Const NM_NCHITTEST					= NM_FIRST-14	; uses NMMOUSE struct
Const NM_KEYDOWN					= NM_FIRST-15	; uses NMKEY struct
Const NM_RELEASEDCAPTURE			= NM_FIRST-16
Const NM_SETCURSOR					= NM_FIRST-17	; uses NMMOUSE struct
Const NM_CHAR						= NM_FIRST-18	; uses NMCHAR struct
Const NM_TOOLTIPSCREATED			= NM_FIRST-19	; notify of when the tooltips window is create

; User Interface - Animation Control Messages & Notifications
Const ACM_OPENA						= WM_USER+100
Const ACM_OPENW						= WM_USER+103
Const ACM_PLAY						= WM_USER+101
Const ACM_STOP						= WM_USER+102
Const ACN_START 					= 1
Const ACN_STOP 						= 2

; User Interface - Button Control Messages & Notifications
Const BCM_FIRST						= $1600	; Button control messages
Const BCN_FIRST						= -1250
Const BCM_GETIDEALSIZE				= BCM_FIRST + $0001
Const BCM_SETIMAGELIST				= BCM_FIRST + $0002
Const BCM_GETIMAGELIST				= BCM_FIRST + $0003
Const BCM_SETTEXTMARGIN				= BCM_FIRST + $0004
Const BCM_GETTEXTMARGIN				= BCM_FIRST + $0005
Const BM_GETCHECK					= $00F0
Const BM_SETCHECK					= $00F1
Const BM_GETSTATE					= $00F2
Const BM_SETSTATE					= $00F3
Const BM_SETSTYLE					= $00F4
Const BM_CLICK						= $00F5
Const BM_GETIMAGE					= $00F6
Const BM_SETIMAGE					= $00F7
Const BCN_HOTITEMCHANGE				= BCN_FIRST + $0001
Const BN_CLICKED 					= 0
Const BN_PAINT 						= 1
Const BN_HILITE 					= 2
Const BN_UNHILITE 					= 3
Const BN_DISABLE 					= 4
Const BN_DOUBLECLICKED 				= 5
Const BN_PUSHED 					= BN_HILITE
Const BN_UNPUSHED 					= BN_UNHILITE
Const BN_DBLCLK 					= BN_DOUBLECLICKED
Const BN_SETFOCUS 					= 6
Const BN_KILLFOCUS 					= 7
Const WM_CTLCOLORBTN				= $0135

; User Interface - ComboBox Control Messages & Notifications
Const CB_GETEDITSEL					= $0140
Const CB_LIMITTEXT					= $0141
Const CB_SETEDITSEL					= $0142
Const CB_ADDSTRING					= $0143
Const CB_DELETESTRING				= $0144
Const CB_DIR						= $0145
Const CB_GETCOUNT					= $0146
Const CB_GETCURSEL					= $0147
Const CB_GETLBTEXT					= $0148
Const CB_GETLBTEXTLEN				= $0149
Const CB_INSERTSTRING				= $014A
Const CB_RESETCONTENT				= $014B
Const CB_FINDSTRING					= $014C
Const CB_SELECTSTRING				= $014D
Const CB_SETCURSEL					= $014E
Const CB_SHOWDROPDOWN				= $014F
Const CB_GETITEMDATA				= $0150
Const CB_SETITEMDATA				= $0151
Const CB_GETDROPPEDCONTROLRECT		= $0152
Const CB_SETITEMHEIGHT				= $0153
Const CB_GETITEMHEIGHT				= $0154
Const CB_SETEXTENDEDUI				= $0155
Const CB_GETEXTENDEDUI				= $0156
Const CB_GETDROPPEDSTATE			= $0157
Const CB_FINDSTRINGEXACT			= $0158
Const CB_SETLOCALE					= $0159
Const CB_GETLOCALE					= $015A
Const CB_GETTOPINDEX				= $015b
Const CB_SETTOPINDEX				= $015c
Const CB_GETHORIZONTALEXTENT		= $015d
Const CB_SETHORIZONTALEXTENT		= $015e
Const CB_GETDROPPEDWIDTH			= $015f
Const CB_SETDROPPEDWIDTH			= $0160
Const CB_INITSTORAGE				= $0161
Const CB_MULTIPLEADDSTRING			= $0163
Const CB_GETCOMBOBOXINFO			= $0164
Const CBN_ERRSPACE					= -1
Const CBN_SELCHANGE					= 1
Const CBN_DBLCLK					= 2
Const CBN_SETFOCUS					= 3
Const CBN_KILLFOCUS					= 4
Const CBN_EDITCHANGE				= 5
Const CBN_EDITUPDATE				= 6
Const CBN_DROPDOWN					= 7
Const CBN_CLOSEUP					= 8
Const CBN_SELENDOK					= 9
Const CBN_SELENDCANCEL				= 10
Const WM_MEASUREITEM				= $002C
Const WM_DRAWITEM					= $002B
Const WM_COMPAREITEM				= $0039

; User Interface - ComboBoxEx Control Messages & Notifications
Const CBEM_INSERTITEMA				= WM_USER + 1
Const CBEM_SETIMAGELIST				= WM_USER + 2
Const CBEM_GETIMAGELIST				= WM_USER + 3
Const CBEM_GETITEMA					= WM_USER + 4
Const CBEM_SETITEMA					= WM_USER + 5
Const CBEM_DELETEITEM 				= CB_DELETESTRING
Const CBEM_GETCOMBOCONTROL			= WM_USER + 6
Const CBEM_GETEDITCONTROL			= WM_USER + 7
Const CBEM_SETEXSTYLE				= WM_USER + 8	; use SETEXTENDEDSTYLE instead
Const CBEM_SETEXTENDEDSTYLE			= WM_USER + 14	; lparam == new style, wParam = optional == mask
Const CBEM_GETEXSTYLE				= WM_USER + 9	; use GETEXTENDEDSTYLE instead
Const CBEM_GETEXTENDEDSTYLE			= WM_USER + 9
Const CBEM_HASEDITCHANGED			= WM_USER + 10
Const CBEM_INSERTITEMW				= WM_USER + 11
Const CBEM_SETITEMW					= WM_USER + 12
Const CBEM_GETITEMW					= WM_USER + 13
Const CBEN_FIRST					= -800	; combo box ex
Const CBEN_GETDISPINFOA				= CBEN_FIRST - 0
Const CBEN_INSERTITEM				= CBEN_FIRST - 1
Const CBEN_DELETEITEM				= CBEN_FIRST - 2
Const CBEN_BEGINEDIT				= CBEN_FIRST - 4
Const CBEN_ENDEDITA					= CBEN_FIRST - 5
Const CBEN_ENDEDITW					= CBEN_FIRST - 6

; User Interface - Date and Time Picker Controls Messages & Notifications
Const DTM_FIRST						= $1000
Const DTM_GETSYSTEMTIME				= DTM_FIRST + 1
Const DTM_SETSYSTEMTIME				= DTM_FIRST + 2
Const DTM_GETRANGE					= DTM_FIRST + 3
Const DTM_SETRANGE					= DTM_FIRST + 4
Const DTM_SETFORMATA				= DTM_FIRST + 5
Const DTM_SETMCCOLOR				= DTM_FIRST + 6
Const DTM_GETMCCOLOR				= DTM_FIRST + 7
Const DTM_GETMONTHCAL				= DTM_FIRST + 8
Const DTM_SETMCFONT					= DTM_FIRST + 9
Const DTM_GETMCFONT					= DTM_FIRST + 10

; User Interface - Drag List Box Notifications
Const DL_BEGINDRAG					= WM_USER+133
Const DL_DRAGGING					= WM_USER+134
Const DL_DROPPED					= WM_USER+135
Const DL_CANCELDRAG					= WM_USER+136

; User Interface - Edit Control Notifications
Const WM_UNDO						= $0304
Const EM_GETSEL						= $00B0
Const EM_SETSEL						= $00B1
Const EM_GETRECT					= $00B2
Const EM_SETRECT					= $00B3
Const EM_SETRECTNP					= $00B4
Const EM_SCROLL						= $00B5
Const EM_LINESCROLL					= $00B6
Const EM_SCROLLCARET				= $00B7
Const EM_GETMODIFY					= $00B8
Const EM_SETMODIFY					= $00B9
Const EM_GETLINECOUNT				= $00BA
Const EM_LINEINDEX					= $00BB
Const EM_SETHANDLE					= $00BC
Const EM_GETHANDLE					= $00BD
Const EM_GETTHUMB					= $00BE
Const EM_LINELENGTH					= $00C1
Const EM_REPLACESEL					= $00C2
Const EM_GETLINE					= $00C4
Const EM_LIMITTEXT					= $00C5
Const EM_CANUNDO					= $00C6
Const EM_UNDO						= $00C7
Const EM_FMTLINES					= $00C8
Const EM_LINEFROMCHAR				= $00C9
Const EM_SETTABSTOPS				= $00CB
Const EM_SETPASSWORDCHAR			= $00CC
Const EM_EMPTYUNDOBUFFER			= $00CD
Const EM_GETFIRSTVISIBLELINE		= $00CE
Const EM_SETREADONLY				= $00CF
Const EM_SETWORDBREAKPROC			= $00D0
Const EM_GETWORDBREAKPROC			= $00D1
Const EM_GETPASSWORDCHAR			= $00D2
Const EM_SETMARGINS					= $00D3
Const EM_GETMARGINS					= $00D4
Const EM_SETLIMITTEXT 				= EM_LIMITTEXT	; ;win40 Name change
Const EM_GETLIMITTEXT				= $00D5
Const EM_POSFROMCHAR				= $00D6
Const EM_CHARFROMPOS				= $00D7
Const EM_SETIMESTATUS				= $00D8
Const EM_GETIMESTATUS				= $00D9
Const EN_SETFOCUS					= $0100
Const EN_KILLFOCUS					= $0200
Const EN_CHANGE						= $0300
Const EN_UPDATE						= $0400
Const EN_ERRSPACE					= $0500
Const EN_MAXTEXT					= $0501
Const EN_HSCROLL					= $0601
Const EN_VSCROLL					= $0602
Const EN_ALIGN_LTR_EC				= $0700
Const EN_ALIGN_RTL_EC				= $0701

; User Interface - Hot Key Control Messages
Const HKM_SETHOTKEY					= WM_USER+1
Const HKM_GETHOTKEY					= WM_USER+2
Const HKM_SETRULES					= WM_USER+3

; User Interface - IP Address Control Messages & Notifications
Const IPN_FIRST						= -860	; internet address
Const IPM_CLEARADDRESS				= WM_USER+100	; no parameters
Const IPM_SETADDRESS				= WM_USER+101	; lparam = TCP/IP address
Const IPM_GETADDRESS				= WM_USER+102	; lresult = # of non black fields. lparam = LPDWORD for TCP/IP address
Const IPM_SETRANGE					= WM_USER+103	; wparam = field, lparam = range
Const IPM_SETFOCUS					= WM_USER+104	; wparam = field
Const IPM_ISBLANK					= WM_USER+105	; no parameters
Const IPN_FIELDCHANGED				= IPN_FIRST - 0

; User Interface - ListBox Messages & Notifications
Const LB_ADDSTRING					= $0180
Const LB_INSERTSTRING				= $0181
Const LB_DELETESTRING				= $0182
Const LB_SELITEMRANGEEX				= $0183
Const LB_RESETCONTENT				= $0184
Const LB_SETSEL						= $0185
Const LB_SETCURSEL					= $0186
Const LB_GETSEL						= $0187
Const LB_GETCURSEL					= $0188
Const LB_GETTEXT					= $0189
Const LB_GETTEXTLEN					= $018A
Const LB_GETCOUNT					= $018B
Const LB_SELECTSTRING				= $018C
Const LB_DIR						= $018D
Const LB_GETTOPINDEX				= $018E
Const LB_FINDSTRING					= $018F
Const LB_GETSELCOUNT				= $0190
Const LB_GETSELITEMS				= $0191
Const LB_SETTABSTOPS				= $0192
Const LB_GETHORIZONTALEXTENT		= $0193
Const LB_SETHORIZONTALEXTENT		= $0194
Const LB_SETCOLUMNWIDTH				= $0195
Const LB_ADDFILE					= $0196
Const LB_SETTOPINDEX				= $0197
Const LB_GETITEMRECT				= $0198
Const LB_GETITEMDATA				= $0199
Const LB_SETITEMDATA				= $019A
Const LB_SELITEMRANGE				= $019B
Const LB_SETANCHORINDEX				= $019C
Const LB_GETANCHORINDEX				= $019D
Const LB_SETCARETINDEX				= $019E
Const LB_GETCARETINDEX				= $019F
Const LB_SETITEMHEIGHT				= $01A0
Const LB_GETITEMHEIGHT				= $01A1
Const LB_FINDSTRINGEXACT			= $01A2
Const LB_SETLOCALE					= $01A5
Const LB_GETLOCALE					= $01A6
Const LB_SETCOUNT					= $01A7
Const LB_INITSTORAGE				= $01A8
Const LB_ITEMFROMPOINT				= $01A9
Const LB_MULTIPLEADDSTRING			= $01B1
Const LB_GETLISTBOXINFO				= $01B2
Const LBN_ERRSPACE					= -2
Const LBN_SELCHANGE					= 1
Const LBN_DBLCLK					= 2
Const LBN_SELCANCEL					= 3
Const LBN_SETFOCUS					= 4
Const LBN_KILLFOCUS					= 5
Const WM_CHARTOITEM					= $002F
Const WM_CTLCOLORLISTBOX			= $0134
Const WM_DELETEITEM					= $002D
Const WM_VKEYTOITEM					= $002E

; User Interface - List-View Messages & Notifications
Const LVM_FIRST						= $1000
Const LVM_GETBKCOLOR				= LVM_FIRST + 0
Const LVM_SETBKCOLOR				= LVM_FIRST + 1
Const LVM_GETIMAGELIST				= LVM_FIRST + 2
Const LVM_SETIMAGELIST				= LVM_FIRST + 3
Const LVM_GETITEMCOUNT				= LVM_FIRST + 4
Const LVM_GETITEMA					= LVM_FIRST + 5
Const LVM_GETITEMW					= LVM_FIRST + 75
Const LVM_GETITEM					= LVM_GETITEMA
Const LVM_SETITEMA					= LVM_FIRST + 6
Const LVM_SETITEMW					= LVM_FIRST + 76
Const LVM_SETITEM					= LVM_SETITEMA
Const LVM_INSERTITEMA				= LVM_FIRST + 7
Const LVM_INSERTITEMW				= LVM_FIRST + 77
Const LVM_INSERTITEM				= LVM_INSERTITEMA
Const LVM_DELETEITEM				= LVM_FIRST + 8
Const LVM_DELETEALLITEMS			= LVM_FIRST + 9
Const LVM_GETCALLBACKMASK			= LVM_FIRST + 10
Const LVM_SETCALLBACKMASK			= LVM_FIRST + 11
Const LVM_GETNEXTITEM				= LVM_FIRST + 12
Const LVM_FINDITEMA					= LVM_FIRST + 13
Const LVM_FINDITEMW					= LVM_FIRST + 83
Const LVM_FINDITEM					= LVM_FINDITEMA
Const LVM_GETITEMRECT				= LVM_FIRST + 14
Const LVM_SETITEMPOSITION			= LVM_FIRST + 15
Const LVM_GETITEMPOSITION			= LVM_FIRST + 16
Const LVM_GETSTRINGWIDTHA			= LVM_FIRST + 17
Const LVM_GETSTRINGWIDTHW			= LVM_FIRST + 87
Const LVM_GETSTRINGWIDTH			= LVM_GETSTRINGWIDTHA
Const LVM_HITTEST					= LVM_FIRST + 18
Const LVM_ENSUREVISIBLE				= LVM_FIRST + 19
Const LVM_SCROLL					= LVM_FIRST + 20
Const LVM_REDRAWITEMS				= LVM_FIRST + 21
Const LVM_ARRANGE					= LVM_FIRST + 22
Const LVM_EDITLABELA				= LVM_FIRST + 23
Const LVM_EDITLABELW				= LVM_FIRST + 118
Const LVM_EDITLABEL					= LVM_EDITLABELA
Const LVM_GETEDITCONTROL			= LVM_FIRST + 24
Const LVM_GETCOLUMNA				= LVM_FIRST + 25
Const LVM_GETCOLUMNW				= LVM_FIRST + 95
Const LVM_GETCOLUMN					= LVM_GETCOLUMNA
Const LVM_SETCOLUMNA				= LVM_FIRST + 26
Const LVM_SETCOLUMNW				= LVM_FIRST + 96
Const LVM_SETCOLUMN					= LVM_SETCOLUMNA
Const LVM_INSERTCOLUMNA				= LVM_FIRST + 27
Const LVM_INSERTCOLUMNW				= LVM_FIRST + 97
Const LVM_INSERTCOLUMN				= LVM_INSERTCOLUMNA
Const LVM_DELETECOLUMN				= LVM_FIRST + 28
Const LVM_GETCOLUMNWIDTH			= LVM_FIRST + 29
Const LVM_SETCOLUMNWIDTH			= LVM_FIRST + 30
Const LVM_GETHEADER					= LVM_FIRST + 31
Const LVM_CREATEDRAGIMAGE			= LVM_FIRST + 33
Const LVM_GETVIEWRECT				= LVM_FIRST + 34
Const LVM_GETTEXTCOLOR				= LVM_FIRST + 35
Const LVM_SETTEXTCOLOR				= LVM_FIRST + 36
Const LVM_GETTEXTBKCOLOR			=LVM_FIRST + 37
Const LVM_SETTEXTBKCOLOR			= LVM_FIRST + 38
Const LVM_GETTOPINDEX				= LVM_FIRST + 39
Const LVM_GETCOUNTPERPAGE			= LVM_FIRST + 40
Const LVM_GETORIGIN					= LVM_FIRST + 41
Const LVM_UPDATE					= LVM_FIRST + 42
Const LVM_SETITEMSTATE				= LVM_FIRST + 43
Const LVM_GETITEMSTATE				= LVM_FIRST + 44
Const LVM_GETITEMTEXTA				= LVM_FIRST + 45
Const LVM_GETITEMTEXTW				= LVM_FIRST + 115
Const LVM_GETITEMTEXT				= LVM_GETITEMTEXTA
Const LVM_SETITEMTEXTA				= LVM_FIRST + 46
Const LVM_SETITEMTEXTW				= LVM_FIRST + 116
Const LVM_SETITEMTEXT				= LVM_SETITEMTEXTA
Const LVM_SETITEMCOUNT				= LVM_FIRST + 47
Const LVM_SORTITEMS					= LVM_FIRST + 48
Const LVM_SETITEMPOSITION32			= LVM_FIRST + 49
Const LVM_GETSELECTEDCOUNT			= LVM_FIRST + 50
Const LVM_GETITEMSPACING			= LVM_FIRST + 51
Const LVM_GETISEARCHSTRINGA			= LVM_FIRST + 52
Const LVM_GETISEARCHSTRINGW			= LVM_FIRST + 117
Const LVM_GETISEARCHSTRING			= LVM_GETISEARCHSTRINGA
Const LVM_SETICONSPACING			= LVM_FIRST + 53
Const LVM_SETEXTENDEDLISTVIEWSTYLE	= LVM_FIRST + 54
Const LVM_GETEXTENDEDLISTVIEWSTYLE	= LVM_FIRST + 55
Const LVM_GETSUBITEMRECT			= LVM_FIRST + 56
Const LVM_SUBITEMHITTEST			= LVM_FIRST + 57
Const LVM_SETCOLUMNORDERARRAY		= LVM_FIRST + 58
Const LVM_GETCOLUMNORDERARRAY		= LVM_FIRST + 59
Const LVM_SETHOTITEM				= LVM_FIRST + 60
Const LVM_GETHOTITEM				= LVM_FIRST + 61
Const LVM_SETHOTCURSOR				= LVM_FIRST + 62
Const LVM_GETHOTCURSOR				= LVM_FIRST + 63
Const LVM_APPROXIMATEVIEWRECT		= LVM_FIRST + 64
Const LVM_SETWORKAREAS				= LVM_FIRST + 65
Const LVM_GETWORKAREAS				= LVM_FIRST + 70
Const LVM_GETNUMBEROFWORKAREAS		= LVM_FIRST + 73
Const LVM_GETSELECTIONMARK			= LVM_FIRST + 66
Const LVM_SETSELECTIONMARK			= LVM_FIRST + 67
Const LVM_SETHOVERTIME				= LVM_FIRST + 71
Const LVM_GETHOVERTIME				= LVM_FIRST + 72
Const LVM_SETTOOLTIPS				= LVM_FIRST + 74
Const LVM_GETTOOLTIPS				= LVM_FIRST + 78
Const LVM_SORTITEMSEX				= LVM_FIRST + 81
Const LVM_SETBKIMAGEA				= LVM_FIRST + 68
Const LVM_SETBKIMAGEW				= LVM_FIRST + 138
Const LVM_GETBKIMAGEA				= LVM_FIRST + 69
Const LVM_GETBKIMAGEW				= LVM_FIRST + 139
Const LVM_SETSELECTEDCOLUMN			= LVM_FIRST + 140
Const LVM_SETTILEWIDTH				= LVM_FIRST + 141
Const LVM_SETVIEW					= LVM_FIRST + 142
Const LVM_GETVIEW					= LVM_FIRST + 143
Const LVM_INSERTGROUP				= LVM_FIRST + 145
Const LVM_SETGROUPINFO				= LVM_FIRST + 147
Const LVM_GETGROUPINFO				= LVM_FIRST + 149
Const LVM_REMOVEGROUP				= LVM_FIRST + 150
Const LVM_MOVEGROUP					= LVM_FIRST + 151
Const LVM_MOVEITEMTOGROUP			= LVM_FIRST + 154
Const LVM_SETGROUPMETRICS			= LVM_FIRST + 155
Const LVM_GETGROUPMETRICS			= LVM_FIRST + 156
Const LVM_ENABLEGROUPVIEW			= LVM_FIRST + 157
Const LVM_SORTGROUPS				= LVM_FIRST + 158
Const LVM_INSERTGROUPSORTED			= LVM_FIRST + 159
Const LVM_REMOVEALLGROUPS			= LVM_FIRST + 160
Const LVM_HASGROUP					= LVM_FIRST + 161
Const LVM_SETTILEVIEWINFO			= LVM_FIRST + 162
Const LVM_GETTILEVIEWINFO			= LVM_FIRST + 163
Const LVM_SETTILEINFO				= LVM_FIRST + 164
Const LVM_GETTILEINFO				= LVM_FIRST + 165
Const LVM_SETINSERTMARK				= LVM_FIRST + 166
Const LVM_GETINSERTMARK				= LVM_FIRST + 167
Const LVM_INSERTMARKHITTEST			= LVM_FIRST + 168
Const LVM_GETINSERTMARKRECT			= LVM_FIRST + 169
Const LVM_SETINSERTMARKCOLOR		= LVM_FIRST + 170
Const LVM_GETINSERTMARKCOLOR		= LVM_FIRST + 171
Const LVM_SETINFOTIP				= LVM_FIRST + 173
Const LVM_GETSELECTEDCOLUMN			= LVM_FIRST + 174
Const LVM_ISGROUPVIEWENABLED		= LVM_FIRST + 175
Const LVM_GETOUTLINECOLOR			= LVM_FIRST + 176
Const LVM_SETOUTLINECOLOR			= LVM_FIRST + 177
Const LVM_CANCELEDITLABEL			= LVM_FIRST + 179
Const LVM_MAPINDEXTOID				= LVM_FIRST + 180
Const LVM_MAPIDTOINDEX				= LVM_FIRST + 181
Const LVM_SETBKIMAGE				= LVM_SETBKIMAGEA
Const LVM_GETBKIMAGE				= LVM_GETBKIMAGEA
Const LVN_FIRST					 	= -100
Const LVN_LAST						= -199
Const LVN_ITEMCHANGING				= LVN_FIRST-0
Const LVN_ITEMCHANGED				= LVN_FIRST-1
Const LVN_INSERTITEM				= LVN_FIRST-2
Const LVN_DELETEITEM				= LVN_FIRST-3
Const LVN_DELETEALLITEMS			= LVN_FIRST-4
Const LVN_BEGINLABELEDITA			= LVN_FIRST-5
Const LVN_BEGINLABELEDITW			= LVN_FIRST-75
Const LVN_ENDLABELEDITA				= LVN_FIRST-6
Const LVN_ENDLABELEDITW				= LVN_FIRST-76
Const LVN_COLUMNCLICK				= LVN_FIRST-8
Const LVN_BEGINDRAG					= LVN_FIRST-9
Const LVN_BEGINRDRAG				= LVN_FIRST-11
Const LVN_ODCACHEHINT				= LVN_FIRST-13
Const LVN_ODFINDITEMA				= LVN_FIRST-52
Const LVN_ODFINDITEMW				= LVN_FIRST-79
Const LVN_ITEMACTIVATE				= LVN_FIRST-14
Const LVN_ODSTATECHANGED			= LVN_FIRST-15
Const LVN_ODFINDITEM				= LVN_ODFINDITEMA
Const LVN_HOTTRACK					= LVN_FIRST-21
Const LVN_GETDISPINFOA				= LVN_FIRST-50
Const LVN_GETDISPINFOW				= LVN_FIRST-77
Const LVN_SETDISPINFOA				= LVN_FIRST-51
Const LVN_SETDISPINFOW				= LVN_FIRST-78
Const LVN_BEGINLABELEDIT			= LVN_BEGINLABELEDITA
Const LVN_ENDLABELEDIT				= LVN_ENDLABELEDITA
Const LVN_GETDISPINFO				= LVN_GETDISPINFOA
Const LVN_SETDISPINFO				= LVN_SETDISPINFOA
Const LVN_KEYDOWN					= LVN_FIRST-55
Const LVN_MARQUEEBEGIN				= LVN_FIRST-56
Const LVN_GETINFOTIPA				= LVN_FIRST-57
Const LVN_GETINFOTIPW				= LVN_FIRST-58
Const LVN_GETINFOTIP				= LVN_GETINFOTIPA
Const LVN_BEGINSCROLL				= LVN_FIRST-80				
Const LVN_ENDSCROLL					= LVN_FIRST-81


; User Interface - Scroll Bar Messages & Notifications
Const SBM_SETPOS					= $00E0 ;not in win3.1
Const SBM_GETPOS					= $00E1 ;not in win3.1
Const SBM_SETRANGE					= $00E2 ;not in win3.1
Const SBM_SETRANGEREDRAW			= $00E6 ;not in win3.1
Const SBM_GETRANGE					= $00E3 ;not in win3.1
Const SBM_ENABLE_ARROWS				= $00E4 ;not in win3.1
Const SBM_SETSCROLLINFO				= $00E9
Const SBM_GETSCROLLINFO				= $00EA
Const WM_CTLCOLORSCROLLBAR			= $0137
Const WM_HSCROLL					= $0114
Const WM_VSCROLL					= $0115

; User Interface - Static Control Messages & Notifications
Const STM_SETICON					= $0170
Const STM_GETICON					= $0171
Const STM_SETIMAGE					= $0172
Const STM_GETIMAGE					= $0173
Const STN_CLICKED					= 0
Const STN_DBLCLK					= 1
Const STN_ENABLE					= 2
Const STN_DISABLE					= 3
Const WM_CTLCOLORSTATIC				= $0138

; User Interface - Status Bar Messages & Notifications
Const SB_SETTIPTEXTA				= WM_USER+16
Const SB_SETTIPTEXTW				= WM_USER+17
Const SB_GETTIPTEXTA				= WM_USER+18
Const SB_GETTIPTEXTW				= WM_USER+19
Const SB_SETTEXTA					= WM_USER+1
Const SB_SETTEXTW					= WM_USER+11
Const SB_GETTEXTA					= WM_USER+2
Const SB_GETTEXTW					= WM_USER+13
Const SB_GETTEXTLENGTHA				= WM_USER+3
Const SB_GETTEXTLENGTHW				= WM_USER+12
Const SB_GETTEXT					= SB_GETTEXTA
Const SB_SETTEXT					= SB_SETTEXTA
Const SB_GETTEXTLENGTH				= SB_GETTEXTLENGTHA
Const SB_SETTIPTEXT					= SB_SETTIPTEXTA
Const SB_GETTIPTEXT					= SB_GETTIPTEXTA
Const SB_SETPARTS					= WM_USER+4
Const SB_GETPARTS					= WM_USER+6
Const SB_GETBORDERS					= WM_USER+7
Const SB_SETMINHEIGHT				= WM_USER+8
Const SB_SIMPLE						= WM_USER+9
Const SB_GETRECT					= WM_USER+10
Const SB_SETICON					= WM_USER+15
Const SB_GETICON					= WM_USER+20
Const SBN_FIRST						= -880	; status bar
Const SBN_SIMPLEMODECHANGE			= SBN_FIRST - 0

; User Interface - Tab Control Messages & Notifications
Const TCM_FIRST						= $1300	; Tab control messages
Const TCM_GETIMAGELIST				= TCM_FIRST + 2
Const TCM_SETIMAGELIST				= TCM_FIRST + 3
Const TCM_GETITEMCOUNT				= TCM_FIRST + 4
Const TCM_GETITEMA					= TCM_FIRST + 5
Const TCM_GETITEMW					= TCM_FIRST + 60
Const TCM_GETITEM 					= TCM_GETITEMA
Const TCM_SETITEMA					= TCM_FIRST + 6
Const TCM_SETITEMW					= TCM_FIRST + 61
Const TCM_SETITEM 					= TCM_SETITEMA
Const TCM_INSERTITEMA				= TCM_FIRST + 7
Const TCM_INSERTITEMW				= TCM_FIRST + 62
Const TCM_INSERTITEM 				= TCM_INSERTITEMA
Const TCM_DELETEITEM				= TCM_FIRST + 8
Const TCM_DELETEALLITEMS			= TCM_FIRST + 9
Const TCM_GETITEMRECT				= TCM_FIRST + 10
Const TCM_GETCURSEL					= TCM_FIRST + 11
Const TCM_SETCURSEL					= TCM_FIRST + 12
Const TCM_HITTEST					= TCM_FIRST + 13
Const TCM_SETITEMEXTRA				= TCM_FIRST + 14
Const TCM_ADJUSTRECT				= TCM_FIRST + 40
Const TCM_SETITEMSIZE				= TCM_FIRST + 41
Const TCM_REMOVEIMAGE				= TCM_FIRST + 42
Const TCM_SETPADDING				= TCM_FIRST + 43
Const TCM_GETROWCOUNT				= TCM_FIRST + 44
Const TCM_GETTOOLTIPS				= TCM_FIRST + 45
Const TCM_SETTOOLTIPS				= TCM_FIRST + 46
Const TCM_GETCURFOCUS				= TCM_FIRST + 47
Const TCM_SETCURFOCUS				= TCM_FIRST + 48
Const TCM_SETMINTABWIDTH			= TCM_FIRST + 49
Const TCM_DESELECTALL				= TCM_FIRST + 50
Const TCM_HIGHLIGHTITEM				= TCM_FIRST + 51
Const TCM_SETEXTENDEDSTYLE			= TCM_FIRST + 52	; optional wParam == mask
Const TCM_GETEXTENDEDSTYLE			= TCM_FIRST + 53
Const TCN_FIRST						= -550	; tab control
Const TCN_KEYDOWN					= TCN_FIRST - 0
Const TCN_SELCHANGE					= TCN_FIRST - 1
Const TCN_SELCHANGING				= TCN_FIRST - 2
Const TCN_GETOBJECT					= TCN_FIRST - 3
Const TCN_FOCUSCHANGE				= TCN_FIRST - 4

; User Interface - Tool Tip Control Messages & Notifications
Const TTM_ACTIVATE					= WM_USER + 1
Const TTM_SETDELAYTIME				= WM_USER + 3
Const TTM_ADDTOOLA					= WM_USER + 4
Const TTM_ADDTOOLW					= WM_USER + 50
Const TTM_DELTOOLA					= WM_USER + 5
Const TTM_DELTOOLW					= WM_USER + 51
Const TTM_NEWTOOLRECTA				= WM_USER + 6
Const TTM_NEWTOOLRECTW				= WM_USER + 52
Const TTM_RELAYEVENT				= WM_USER + 7
Const TTM_GETTOOLINFOA				= WM_USER + 8
Const TTM_GETTOOLINFOW				= WM_USER + 53
Const TTM_SETTOOLINFOA				= WM_USER + 9
Const TTM_SETTOOLINFOW				= WM_USER + 54
Const TTM_HITTESTA					= WM_USER +10
Const TTM_HITTESTW					= WM_USER +55
Const TTM_GETTEXTA					= WM_USER +11
Const TTM_GETTEXTW					= WM_USER +56
Const TTM_UPDATETIPTEXTA			= WM_USER +12
Const TTM_UPDATETIPTEXTW			= WM_USER +57
Const TTM_GETTOOLCOUNT				= WM_USER +13
Const TTM_ENUMTOOLSA				= WM_USER +14
Const TTM_ENUMTOOLSW				= WM_USER +58
Const TTM_GETCURRENTTOOLA			= WM_USER + 15
Const TTM_GETCURRENTTOOLW			= WM_USER + 59
Const TTM_WINDOWFROMPOINT			= WM_USER + 16
Const TTM_TRACKACTIVATE				= WM_USER + 17	; wParam = TRUE/FALSE start end lparam = LPTOOLINFO
Const TTM_TRACKPOSITION				= WM_USER + 18	; lParam = dwPos
Const TTM_SETTIPBKCOLOR				= WM_USER + 19
Const TTM_SETTIPTEXTCOLOR			= WM_USER + 20
Const TTM_GETDELAYTIME				= WM_USER + 21
Const TTM_GETTIPBKCOLOR				= WM_USER + 22
Const TTM_GETTIPTEXTCOLOR			= WM_USER + 23
Const TTM_SETMAXTIPWIDTH			= WM_USER + 24
Const TTM_GETMAXTIPWIDTH			= WM_USER + 25
Const TTM_SETMARGIN					= WM_USER + 26	; lParam = lprc
Const TTM_GETMARGIN					= WM_USER + 27	; lParam = lprc
Const TTM_POP						= WM_USER + 28
Const TTM_UPDATE					= WM_USER + 29
Const TTM_GETBUBBLESIZE				= WM_USER + 30
Const TTM_ADJUSTRECT				= WM_USER + 31
Const TTM_SETTITLEA					= WM_USER + 32	; wParam = TTI_*, lParam = char* szTitle
Const TTM_SETTITLEW					= WM_USER + 33	; wParam = TTI_*, lParam = wchar* szTitle
Const TTM_POPUP						= WM_USER + 34
Const TTM_GETTITLE					= WM_USER + 35	; wParam = 0, lParam = TTGETTITLE*
Const TTN_FIRST						= -520	; tooltips
Const TTN_GETDISPINFOA				= TTN_FIRST - 0
Const TTN_GETDISPINFOW				= TTN_FIRST - 10
Const TTN_SHOW						= TTN_FIRST - 1
Const TTN_POP						= TTN_FIRST - 2
Const TTN_LINKCLICK					= TTN_FIRST - 3

; User Interface - Treeview Notifications
Const TVN_FIRST						= -400
Const TVN_SELCHANGINGA				= TVN_FIRST-1
Const TVN_SELCHANGINGW				= TVN_FIRST-50
Const TVN_SELCHANGEDA				= TVN_FIRST-2
Const TVN_SELCHANGEDW				= TVN_FIRST-51
Const TVN_GETDISPINFOA				= TVN_FIRST-3
Const TVN_GETDISPINFOW				= TVN_FIRST-52
Const TVN_SETDISPINFOA				= TVN_FIRST-4
Const TVN_SETDISPINFOW				= TVN_FIRST-53
Const TVN_ITEMEXPANDINGA			= TVN_FIRST-5
Const TVN_ITEMEXPANDINGW			= TVN_FIRST-54
Const TVN_ITEMEXPANDEDA				= TVN_FIRST-6
Const TVN_ITEMEXPANDEDW				= TVN_FIRST-55
Const TVN_BEGINDRAGA				= TVN_FIRST-7
Const TVN_BEGINDRAGW				= TVN_FIRST-56
Const TVN_BEGINRDRAGA				= TVN_FIRST-8
Const TVN_BEGINRDRAGW				= TVN_FIRST-57
Const TVN_DELETEITEMA				= TVN_FIRST-9
Const TVN_DELETEITEMW				= TVN_FIRST-58
Const TVN_BEGINLABELEDITA			= TVN_FIRST-10
Const TVN_BEGINLABELEDITW			= TVN_FIRST-59
Const TVN_ENDLABELEDITA			 	= TVN_FIRST-11
Const TVN_ENDLABELEDITW			 	= TVN_FIRST-60
Const TVN_KEYDOWN					= TVN_FIRST-12
Const TVN_GETINFOTIPA				= TVN_FIRST-13
Const TVN_GETINFOTIPW				= TVN_FIRST-14
Const TVN_SINGLEEXPAND				= TVN_FIRST-15
Const TVN_SELCHANGING				= TVN_SELCHANGINGA
Const TVN_SELCHANGED				= TVN_SELCHANGEDA
Const TVN_GETDISPINFO				= TVN_GETDISPINFOA
Const TVN_SETDISPINFO				= TVN_SETDISPINFOA
Const TVN_ITEMEXPANDING			 	= TVN_ITEMEXPANDINGA
Const TVN_ITEMEXPANDED				= TVN_ITEMEXPANDEDA
Const TVN_BEGINDRAG					= TVN_BEGINDRAGA
Const TVN_BEGINRDRAG				= TVN_BEGINRDRAGA
Const TVN_DELETEITEM				= TVN_DELETEITEMA
Const TVN_BEGINLABELEDIT			= TVN_BEGINLABELEDITA
Const TVN_ENDLABELEDIT				= TVN_ENDLABELEDITA
Const TVN_GETINFOTIP				= TVN_GETINFOTIPA

; Windows Shell - Shell Messages & Notifications
Const ABM_NEW						= $00000000
Const ABM_REMOVE					= $00000001
Const ABM_QUERYPOS					= $00000002
Const ABM_SETPOS					= $00000003
Const ABM_GETSTATE					= $00000004
Const ABM_GETTASKBARPOS				= $00000005
Const ABM_ACTIVATE					= $00000006	; lParam == TRUE/FALSE means activate/deactivate
Const ABM_GETAUTOHIDEBAR			= $00000007
Const ABM_SETAUTOHIDEBAR			= $00000008	; this can fail at any time. MUST check the result
Const ABM_WINDOWPOSCHANGED			= $0000009
Const ABM_SETSTATE					= $0000000a
Const ABN_STATECHANGE				= $0000000
Const ABN_POSCHANGED				= $0000001
Const ABN_FULLSCREENAPP				= $0000002
Const ABN_WINDOWARRANGE				= $0000003	; lParam == TRUE means hide
Const CPL_INIT 						= 1
Const CPL_GETCOUNT 					= 2
Const CPL_INQUIRE 					= 3
Const CPL_SELECT 					= 4
Const CPL_DBLCLK 					= 5
Const CPL_STOP 						= 6
Const CPL_EXIT 						= 7
Const CPL_NEWINQUIRE 				= 8
Const CPL_STARTWPARMSA 				= 9
Const CPL_STARTWPARMSW 				= 10
Const DFM_MERGECONTEXTMENU 			= 1	; uFlags LPQCMINFO
Const DFM_INVOKECOMMAND 			= 2	; idCmd pszArgs
Const DFM_GETDEFSTATICID 			= 14	; idCmd * 0
Const FM_GETFOCUS					= WM_USER +	$0200
Const FM_GETSELCOUNT				= WM_USER +	$0202
Const FM_GETSELCOUNTLFN				= WM_USER +	$0203	; LFN versions are odd
Const FM_REFRESH_WINDOWS			= WM_USER + $0206
Const FM_RELOAD_EXTENSIONS			= WM_USER +	$0207
Const FM_GETDRIVEINFOA				= WM_USER + $0201
Const FM_GETFILESELA				= WM_USER +	$0204
Const FM_GETFILESELLFNA				= WM_USER +	$0205	; LFN versions are odd
Const FM_GETDRIVEINFOW				= WM_USER +	$0211
Const FM_GETFILESELW				= WM_USER +	$0214
Const FM_GETFILESELLFNW				= WM_USER +	$0215	; LFN versions are odd
Const FMEVENT_LOAD					= 100
Const FMEVENT_UNLOAD				= 101
Const FMEVENT_INITMENU				= 102
Const FMEVENT_USER_REFRESH			= 103
Const FMEVENT_SELCHANGE				= 104
Const FMEVENT_TOOLBARLOAD			= 105
Const FMEVENT_HELPSTRING			= 106
Const FMEVENT_HELPMENUITEM			= 107
Const SFVM_MERGEMENU 				= 1	; - LPQCMINFO
Const SFVM_INVOKECOMMAND			= 2	; idCmd -
Const SFVM_GETHELPTEXT				= 3	; idCmd,cchMax pszText
Const SFVM_GETTOOLTIPTEXT			= 4	; idCmd,cchMax pszText
Const SFVM_GETBUTTONINFO			= 5	; - LPTBINFO
Const SFVM_GETBUTTONS				= 6	; idCmdFirst,cbtnMax LPTBBUTTON
Const SFVM_INITMENUPOPUP			= 7	; idCmdFirst,nIndex hmenu
Const SFVM_FSNOTIFY					= 14	; LPCITEMIDLIST* lEvent
Const SFVM_WINDOWCREATED			= 15	; hwnd -
Const SFVM_GETDETAILSOF				= 23	; iColumn DETAILSINFO*
Const SFVM_COLUMNCLICK				= 24	; iColumn -
Const SFVM_QUERYFSNOTIFY			= 25	; - SHChangeNotifyEntry *
Const SFVM_DEFITEMCOUNT				= 26	; - UINT*
Const SFVM_DEFVIEWMODE				= 27	; - FOLDERVIEWMODE*
Const SFVM_UNMERGEMENU				= 28	; - hmenu
Const SFVM_UPDATESTATUSBAR			= 31	; fInitialize -
Const SFVM_BACKGROUNDENUM			= 32	; - -
Const SFVM_DIDDRAGDROP				= 36	; dwEffect IDataObject *
Const SFVM_SETISFV					= 39	; - IShellFolderView*
Const SFVM_THISIDLIST				= 41	; - LPITMIDLIST*
Const SFVM_ADDPROPERTYPAGES			= 47	; - SFVM_PROPPAGE_DATA *
Const SFVM_BACKGROUNDENUMDONE		= 48	; - -
Const SFVM_GETNOTIFY				= 49	; LPITEMIDLIST* LONG*
Const SFVM_GETSORTDEFAULTS			= 53	; iDirection iParamSort
Const SFVM_SIZE						= 57	; - -
Const SFVM_GETZONE					= 58	; - DWORD*
Const SFVM_GETPANE					= 59	; Pane ID DWORD*
Const SFVM_GETHELPTOPIC				= 63	; - SFVM_HELPTOPIC_DATA *
Const SFVM_GETANIMATION				= 68	; HINSTANCE * WCHAR *
Const WM_DROPFILES					= $0233
Const WM_HELP						= $0053
Const WM_TCARD						= $0052

; User Interface - Clipboard Messages & Notifications
Const WM_CUT						= $0300
Const WM_COPY						= $0301
Const WM_PASTE						= $0302
Const WM_CLEAR						= $0303
Const WM_ASKCBFORMATNAME			= $030C
Const WM_CHANGECBCHAIN				= $030D
Const WM_DESTROYCLIPBOARD			= $0307
Const WM_DRAWCLIPBOARD				= $0308
Const WM_PAINTCLIPBOARD				= $0309
Const WM_VSCROLLCLIPBOARD			= $030A
Const WM_SIZECLIPBOARD				= $030B
Const WM_HSCROLLCLIPBOARD			= $030E
Const WM_RENDERFORMAT				= $0305
Const WM_RENDERALLFORMATS			= $0306

; User Interface - Data Copy Messages
Const WM_COPYDATA					= $004A

; User Interface - Resources - Cursor Notifications
Const WM_SETCURSOR					= $0020

; User Interface - Resources - Icon Notifications
Const WM_ERASEBKGND					= $0014
Const WM_ICONERASEBKGND				= $0027
Const WM_PAINTICON					= $0026

; User Interface - Menus - Menu Notifications
Const WM_COMMAND					= $0111
Const WM_CONTEXTMENU				= $007B
Const WM_ENTERMENULOOP				= $0211
Const WM_EXITMENULOOP				= $0212
Const WM_MENURBUTTONUP				= $0122
Const WM_MENUDRAG					= $0123
Const WM_MENUGETOBJECT				= $0124
Const WM_UNINITMENUPOPUP			= $0125
Const WM_MENUCOMMAND				= $0126
Const WM_NEXTMENU					= $0213

; User Interface - User Input - Keyboard Accelerator Messages & Notifications
Const WM_CHANGEUISTATE				= $0127
Const WM_INITMENU					= $0116
Const WM_QUERYUISTATE				= $0129
Const WM_UPDATEUISTATE				= $0128
Const WM_INITMENUPOPUP				= $0117
Const WM_MENUCHAR					= $0120
Const WM_MENUSELECT					= $011F
Const WM_SYSCHAR					= $0106
Const WM_SYSCOMMAND					= $0112

; User Interface - User Input - Keyboard Input Messages & Notifications
Const WM_SETHOTKEY					= $0032
Const WM_GETHOTKEY					= $0033
Const WM_ACTIVATE					= $0006
Const WM_APPCOMMAND					= $0319
Const WM_CHAR						= $0102
Const WM_DEADCHAR					= $0103
Const WM_HOTKEY						= $0312
Const WM_KEYDOWN					= $0100
Const WM_KEYUP						= $0101
Const WM_KILLFOCUS					= $0008
Const WM_SETFOCUS					= $0007
Const WM_SYSKEYDOWN					= $0104
Const WM_SYSKEYUP					= $0105
Const WM_SYSDEADCHAR				= $0107
Const WM_UNICHAR					= $0109

; User Interface - User Input - Mouse Input Notifications
Const WM_CAPTURECHANGED				= $0215
Const WM_MOUSEMOVE					= $0200
Const WM_LBUTTONDOWN				= $0201
Const WM_LBUTTONUP					= $0202
Const WM_LBUTTONDBLCLK				= $0203
Const WM_RBUTTONDOWN				= $0204
Const WM_RBUTTONUP					= $0205
Const WM_RBUTTONDBLCLK				= $0206
Const WM_MBUTTONDOWN				= $0207
Const WM_MBUTTONUP					= $0208
Const WM_MBUTTONDBLCLK				= $0209
Const WM_MOUSEWHEEL					= $020A
Const WM_XBUTTONDOWN				= $020B
Const WM_XBUTTONUP					= $020C
Const WM_XBUTTONDBLCLK				= $020D
Const WM_MOUSEHOVER					= $02A1
Const WM_MOUSELEAVE					= $02A3
Const WM_NCMOUSEHOVER				= $02A0
Const WM_NCMOUSELEAVE				= $02A2
Const WM_NCHITTEST					= $0084
Const WM_MOUSEACTIVATE				= $0021
Const WM_NCMOUSEMOVE				= $00A0
Const WM_NCLBUTTONDOWN				= $00A1
Const WM_NCLBUTTONUP				= $00A2
Const WM_NCLBUTTONDBLCLK			= $00A3
Const WM_NCRBUTTONDOWN				= $00A4
Const WM_NCRBUTTONUP				= $00A5
Const WM_NCRBUTTONDBLCLK			= $00A6
Const WM_NCMBUTTONDOWN				= $00A7
Const WM_NCMBUTTONUP				= $00A8
Const WM_NCMBUTTONDBLCLK			= $00A9
Const WM_NCXBUTTONDOWN				= $00AB
Const WM_NCXBUTTONUP				= $00AC
Const WM_NCXBUTTONDBLCLK			= $00AD

; User Interface - User Input - Raw Input Notifications
Const WM_INPUT						= $00FF

; User Interface - Windowing - Dialog Box Notifications
Const WM_CTLCOLORDLG				= $0136
Const WM_ENTERIDLE					= $0121
Const WM_GETDLGCODE					= $0087
Const WM_INITDIALOG					= $0110
Const WM_NEXTDLGCTL					= $0028

; User Interface - Windowing - MDI Messages
Const WM_MDICREATE					= $0220
Const WM_MDIDESTROY					= $0221
Const WM_MDIACTIVATE				= $0222
Const WM_MDIRESTORE					= $0223
Const WM_MDINEXT					= $0224
Const WM_MDIMAXIMIZE				= $0225
Const WM_MDITILE					= $0226
Const WM_MDICASCADE					= $0227
Const WM_MDIICONARRANGE				= $0228
Const WM_MDIGETACTIVE				= $0229
Const WM_MDISETMENU					= $0230
Const WM_MDIREFRESHMENU				= $0234

; User Interface - Windowing - Timer Notifications
Const WM_TIMER						= $0113

; User Interface - Windowing - Windows Messages
Const MN_GETHMENU					= $01E1
Const WM_SETFONT					= $0030
Const WM_GETFONT					= $0031
Const WM_SETTEXT					= $000C
Const WM_GETTEXT					= $000D
Const WM_GETTEXTLENGTH				= $000E
Const WM_SETICON					= $0080
Const WM_ACTIVATEAPP				= $001C
Const WM_CANCELMODE					= $001F
Const WM_CHILDACTIVATE				= $0022
Const WM_CLOSE						= $0010
Const WM_COMPACTING					= $0041
Const WM_CREATE						= $0001
Const WM_DESTROY					= $0002
Const WM_ENABLE						= $000A
Const WM_ENTERSIZEMOVE				= $0231
Const WM_EXITSIZEMOVE				= $0232
Const WM_GETICON					= $007F
Const WM_GETMINMAXINFO				= $0024
Const WM_INPUTLANGCHANGEREQUEST		= $0050
Const WM_INPUTLANGCHANGE			= $0051
Const WM_MOVE						= $0003
Const WM_MOVING						= $0216
Const WM_NCCREATE					= $0081
Const WM_NCDESTROY					= $0082
Const WM_NCCALCSIZE					= $0083
Const WM_NCACTIVATE					= $0086
Const WM_NULL						= $0000
Const WM_PARENTNOTIFY				= $0210
Const WM_QUERYDRAGICON				= $0037
Const WM_QUERYOPEN					= $0013
Const WM_QUIT						= $0012
Const WM_SHOWWINDOW					= $0018
Const WM_SIZE						= $0005
Const WM_SIZING						= $0214
Const WM_STYLECHANGING				= $007C
Const WM_STYLECHANGED				= $007D
Const WM_THEMECHANGED				= $031A
Const WM_USERCHANGED				= $0054
Const WM_WINDOWPOSCHANGING			= $0046
Const WM_WINDOWPOSCHANGED			= $0047

; Device Management Messages
Const WM_DEVICECHANGE				= $0219

; Power Management Messages
Const WM_POWER						= $0048
Const WM_POWERBROADCAST				= $0218

; System Information Reference
Const WM_WININICHANGE				= $001A
Const WM_SETTINGCHANGE				= WM_WININICHANGE

; System Shutdown Messages
Const WM_ENDSESSION					= $0016
Const WM_QUERYENDSESSION			= $0011

; Time Messages
Const WM_TIMECHANGE					= $001E

; GDI - Color Messages
Const WM_PALETTECHANGED				= $0311
Const WM_PALETTEISCHANGING			= $0310
Const WM_QUERYNEWPALETTE			= $030F
Const WM_SYSCOLORCHANGE				= $0015

; GDI - Device Context Messages
Const WM_DEVMODECHANGE				= $001B

; GDI - Font and Text Messages
Const WM_FONTCHANGE					= $001D

; GDI - Painting and Drawing Messages
Const WM_DISPLAYCHANGE				= $007E
Const WM_NCPAINT					= $0085
Const WM_PAINT						= $000F
Const WM_PRINT						= $0317
Const WM_PRINTCLIENT				= $0318
Const WM_SETREDRAW					= $000B
Const WM_SYNCPAINT					= $0088

; GDI - Printing and Print Spooler Messages
Const WM_SPOOLERSTATUS				= $002A

; Windows Multimedia - Audio Compression Messages
Const MM_ACM_FORMATCHOOSE			= $8000
Const MM_ACM_FILTERCHOOSE			= $8000

; Windows Multimedia - Audio Mixer Messages
Const MM_MIXM_LINE_CHANGE			= $3D0	; mixer line change notify
Const MM_MIXM_CONTROL_CHANGE		= $3D1	; mixer control change notify

; Windows Multimedia - MCIWnd Messages
Const MCIWNDM_CAN_CONFIG			= WM_USER + 149
Const MCIWNDM_CAN_EJECT				= WM_USER + 148
Const MCIWNDM_CAN_PLAY				= WM_USER + 144
Const MCIWNDM_CAN_RECORD			= WM_USER + 146
Const MCIWNDM_CAN_SAVE				= WM_USER + 147
Const MCIWNDM_CAN_WINDOW			= WM_USER + 145
Const MCIWNDM_CHANGESTYLES			= WM_USER + 135
Const MCIWNDM_EJECT					= WM_USER + 107
Const MCIWNDM_GET_DEST				= WM_USER + 142
Const MCIWNDM_GET_SOURCE			= WM_USER + 140
Const MCIWNDM_GETACTIVETIMER		= WM_USER + 132
Const MCIWNDM_GETALIAS				= WM_USER + 137
Const MCIWNDM_GETDEVICEA			= WM_USER + 125
Const MCIWNDM_GETDEVICEID			= WM_USER + 100
Const MCIWNDM_GETEND				= WM_USER + 105
Const MCIWNDM_GETERRORA				= WM_USER + 128
Const MCIWNDM_GETFILENAMEA			= WM_USER + 124
Const MCIWNDM_GETINACTIVETIMER		= WM_USER + 133
Const MCIWNDM_GETLENGTH				= WM_USER + 104
Const MCIWNDM_GETMODEA				= WM_USER + 106
Const MCIWNDM_GETPALETTE			= WM_USER + 126
Const MCIWNDM_GETPOSITIONA			= WM_USER + 102
Const MCIWNDM_GETREPEAT				= WM_USER + 115
Const MCIWNDM_GETSPEED				= WM_USER + 113
Const MCIWNDM_GETSTART				= WM_USER + 103
Const MCIWNDM_GETSTYLES				= WM_USER + 136
Const MCIWNDM_GETTIMEFORMATA		= WM_USER + 120
Const MCIWNDM_GETVOLUME				= WM_USER + 111
Const MCIWNDM_GETZOOM				= WM_USER + 109
Const MCIWNDM_NEWA					= WM_USER + 134
Const MCIWNDM_NOTIFYMEDIA			= WM_USER + 203	; wp			= hwnd, lp			= fn
Const MCIWNDM_NOTIFYMODE			= WM_USER + 200	; wp			= hwnd, lp			= mode
Const MCIWNDM_NOTIFYPOS				= WM_USER + 201	; wp			= hwnd, lp			= pos
Const MCIWNDM_NOTIFYSIZE			= WM_USER + 202	; wp			= hwnd
Const MCIWNDM_OPENA					= WM_USER + 153
Const MCIWNDM_OPENINTERFACE			= WM_USER + 151
Const MCIWNDM_PALETTEKICK			= WM_USER + 150
Const MCIWNDM_PLAYFROM				= WM_USER + 122
Const MCIWNDM_PLAYREVERSE			= WM_USER + 139
Const MCIWNDM_PLAYTO				= WM_USER + 123
Const MCIWNDM_PUT_DEST				= WM_USER + 143
Const MCIWNDM_PUT_SOURCE			= WM_USER + 141
Const MCIWNDM_REALIZE				= WM_USER + 118
Const MCIWNDM_RETURNSTRINGA			= WM_USER + 138
Const MCIWNDM_SENDSTRINGA			= WM_USER + 101
Const MCIWNDM_SETACTIVETIMER		= WM_USER + 130
Const MCIWNDM_SETINACTIVETIMER		= WM_USER + 131
Const MCIWNDM_SETOWNER				= WM_USER + 152
Const MCIWNDM_SETPALETTE			= WM_USER + 127
Const MCIWNDM_SETREPEAT				= WM_USER + 114
Const MCIWNDM_SETSPEED				= WM_USER + 112
Const MCIWNDM_SETTIMEFORMATA		= WM_USER + 119
Const MCIWNDM_SETTIMERS				= WM_USER + 129
Const MCIWNDM_SETVOLUME				= WM_USER + 110
Const MCIWNDM_SETZOOM				= WM_USER + 108
Const MCIWNDM_VALIDATEMEDIA			= WM_USER + 121

; Windows Multimedia - MCI Messages
Const MM_MCINOTIFY					= $3B9	; MCI
Const MM_MCISIGNAL					= $3CB

; Windows Multimedia - MIDI and Waveform Messages
Const MM_MIM_OPEN					= $3C1	; MIDI input
Const MM_MIM_CLOSE					= $3C2
Const MM_MIM_DATA					= $3C3
Const MM_MIM_LONGDATA				= $3C4
Const MM_MIM_ERROR					= $3C5
Const MM_MIM_LONGERROR				= $3C6
Const MM_MIM_MOREDATA				= $3CC	; MIM_DONE w/ pending events
Const MM_MOM_OPEN					= $3C7	; MIDI output
Const MM_MOM_CLOSE					= $3C8
Const MM_MOM_DONE					= $3C9
Const MM_MOM_POSITIONCB				= $3CA	; Callback for MEVT_POSITIONCB
Const MIM_OPEN						= MM_MIM_OPEN
Const MIM_CLOSE						= MM_MIM_CLOSE
Const MIM_DATA						= MM_MIM_DATA
Const MIM_LONGDATA					= MM_MIM_LONGDATA
Const MIM_ERROR						= MM_MIM_ERROR
Const MIM_LONGERROR					= MM_MIM_LONGERROR
Const MOM_OPEN						= MM_MOM_OPEN
Const MOM_CLOSE						= MM_MOM_CLOSE
Const MOM_DONE						= MM_MOM_DONE

; Windows Multimedia - Multimedia File I/O Messages
Const MMIOM_SEEK 					= 2	; seek to a new position in file
Const MMIOM_OPEN 					= 3	; open file
Const MMIOM_CLOSE 					= 4	; close file
Const MMIOM_WRITEFLUSH 				= 5	; write and flush
Const MMIOM_RENAME 					= 6	; rename specified file

; Windows Multimedia - Multimedia Joystick Messages
Const MM_JOY1MOVE					= $3A0	; joystick
Const MM_JOY2MOVE					= $3A1
Const MM_JOY1ZMOVE					= $3A2
Const MM_JOY2ZMOVE					= $3A3
Const MM_JOY1BUTTONDOWN				= $3B5
Const MM_JOY2BUTTONDOWN				= $3B6
Const MM_JOY1BUTTONUP				= $3B7
Const MM_JOY2BUTTONUP				= $3B8
