; Required BLESS functions:
; 1) Bless_RegisterEvent:
;   Tells BLESS that you want to receive notification of a certain event occurrance
; 2) Bless_UnregisterEvent:
;   Frees up resources used when registering an event with BLESS.
;   Highly recommended to use before program termination.
; 3) Bless_EventData:
;   Used to retrieve extended information about an event occurance.
; 4) Bless_UseAlternateMethod:
;   Switches registered event notification methods, for compatibility purposes.

.lib "Bless.dll"
Bless_RegisterEvent%(BlessID%, WindowsEvent%, hwndSource%, hwndDest%):"RegisterEvent"
Bless_UnregisterEvent%(BlessID%):"UnregisterEvent"
Bless_EventData(BlessID%, evd*):"EventData"
Bless_UseAlternateMethod(bAlt%):"UseAlternateMethod"


; ------------------------------------- 
; The following are used in the example programs only and are not necessarily part of BLESS
; They are standard Windows API routines.  Look them up on MSDN.

.lib "kernel32.dll"
Bless_CopyMemory(Dest*, Src%, Length%):"RtlMoveMemory"

.lib "shell32.dll"
Bless_NotifyIcon%(messageFlag,NotifyIconData*):"Shell_NotifyIconA"
Bless_ExtractIcon%(hInstance,iconFilename$,iconIndex):"ExtractIconA"
Bless_DragAcceptFiles(hwnd%,bAccept%):"DragAcceptFiles"
Bless_DragQueryFile(hdrop%, iFile%, lpszFile$, cch%):"DragQueryFile"
Bless_DragQueryFile3D%(hdrop%, iFile%, lpszFile*, cch%):"DragQueryFile"
Bless_DragFinish(hdrop%):"DragFinish"

.lib "user32.dll"
Bless_GetForegroundWindow%():"GetForegroundWindow"
Bless_GetWindowPlacement%(hwnd%, wp*):"GetWindowPlacement"
Bless_SetWindowPlacement%(hwnd%, wp*):"SetWindowPlacement"
Bless_GetDC%(hwnd%):"GetDC"
Bless_ReleaseDC%(hwnd%, hDC%):"ReleaseDC"
Bless_SendMessage%(hwnd%, message%, lparam%, wparam%):"SendMessageA"
Bless_FindWindowEx%(parent%, child%, class$, title$):"FindWindowExA"

.lib "gdi32.dll"
Bless_SelectObject%(hDC%, hobj%):"SelectObject"
Bless_DeleteObject%(hobj%):"DeleteObject"
Bless_CreatePen%(style%, width%, hue%):"CreatePen"
Bless_Rectangle%(hDC%, x%, y%, sx%, sy%):"Rectangle"
Bless_TextOut%(hDC%, x%, y%, lpString$, length%):"TextOutA"
